/*
 * Decompiled with CFR 0.152.
 */
package org.otfried.cs109ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.otfried.cs109.Canvas;
import org.otfried.cs109.Color;
import org.otfried.cs109.DrawStyle;
import org.otfried.cs109.TextAlign;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J0\u0010&\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016J\u0018\u00100\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016J\b\u00101\u001a\u00020\u0016H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020#H\u0016J\b\u00104\u001a\u00020\u0016H\u0016J\u0018\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020#H\u0016J\u0010\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\fH\u0016J\u0010\u0010:\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010;\u001a\u00020\u00162\u0006\u0010<\u001a\u00020#2\u0006\u0010=\u001a\u00020,H\u0016J\u0010\u0010>\u001a\u00020\u00162\u0006\u0010'\u001a\u00020#H\u0016J\u0010\u0010?\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020,H\u0016J\u0010\u0010@\u001a\u00020#2\u0006\u00103\u001a\u00020#H\u0002J\u0018\u0010A\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e"}, d2={"Lorg/otfried/cs109ui/ImageCanvas;", "Lorg/otfried/cs109/Canvas;", "img", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "ctm", "", "Ljava/awt/geom/AffineTransform;", "g", "Ljava/awt/Graphics2D;", "kotlin.jvm.PlatformType", "height", "", "getHeight", "()I", "getImg", "()Ljava/awt/image/BufferedImage;", "path", "Ljava/awt/geom/Path2D$Double;", "width", "getWidth", "beginShape", "", "clear", "c", "Lorg/otfried/cs109/Color;", "closePath", "done", "draw", "s", "Lorg/otfried/cs109/DrawStyle;", "shape", "Ljava/awt/Shape;", "drawCircle", "x", "", "y", "r", "drawRectangle", "w", "h", "drawShape", "drawText", "text", "", "align", "Lorg/otfried/cs109/TextAlign;", "lineTo", "moveTo", "restore", "rotate", "degrees", "save", "scale", "sx", "sy", "setAlpha", "a", "setColor", "setFont", "size", "font", "setLineWidth", "textWidth", "toRadians", "translate"})
public final class ImageCanvas
implements Canvas {
    private final Graphics2D g;
    private final List<AffineTransform> ctm;
    private Path2D.Double path;
    @NotNull
    private final BufferedImage img;

    private final void draw(DrawStyle s, Shape shape) {
        if (Intrinsics.areEqual((Object)s, (Object)DrawStyle.STROKE) ^ true) {
            this.g.fill(shape);
        }
        if (Intrinsics.areEqual((Object)s, (Object)DrawStyle.FILL) ^ true) {
            this.g.draw(shape);
        }
    }

    private final double toRadians(double degrees) {
        return degrees / 180.0 * Math.PI;
    }

    public int getWidth() {
        return this.img.getWidth();
    }

    public int getHeight() {
        return this.img.getHeight();
    }

    public void clear(@NotNull Color c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Graphics2D graphics2D = this.g;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D, (String)"g");
        AffineTransform tfm = graphics2D.getTransform();
        this.g.setColor(new java.awt.Color(c.getR(), c.getG(), c.getB()));
        Graphics2D graphics2D2 = this.g;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D2, (String)"g");
        graphics2D2.setTransform((AffineTransform)CollectionsKt.first(this.ctm));
        this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D graphics2D3 = this.g;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D3, (String)"g");
        graphics2D3.setTransform(tfm);
    }

    public void setColor(@NotNull Color c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        this.g.setColor(new java.awt.Color(c.getR(), c.getG(), c.getB()));
    }

    public void setAlpha(int a) {
        this.g.setComposite(AlphaComposite.getInstance(3, (float)a / 255.0f));
    }

    public void setLineWidth(double w) {
        this.g.setStroke(new BasicStroke((float)w));
    }

    public void setFont(double size, @NotNull String font) {
        Intrinsics.checkParameterIsNotNull((Object)font, (String)"font");
        this.g.setFont(new Font(font, 0, (int)size));
    }

    public void drawRectangle(double x, double y, double w, double h, @NotNull DrawStyle s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.draw(s, new Rectangle2D.Double(x, y, w, h));
    }

    public void drawCircle(double x, double y, double r, @NotNull DrawStyle s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.draw(s, new Ellipse2D.Double(x - r, y - r, (double)2 * r, (double)2 * r));
    }

    public void drawText(@NotNull String text, double x, double y, @NotNull TextAlign align) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)align, (String)"align");
        float x0 = (float)x;
        if (Intrinsics.areEqual((Object)align, (Object)TextAlign.LEFT) ^ true) {
            int w = this.g.getFontMetrics().stringWidth(text);
            x0 = Intrinsics.areEqual((Object)align, (Object)TextAlign.RIGHT) ? (x0 -= (float)w) : (x0 -= (float)w / 2.0f);
        }
        this.g.drawString(text, x0, (float)y);
    }

    public double textWidth(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        return this.g.getFontMetrics().stringWidth(s);
    }

    public void beginShape() {
        this.path = new Path2D.Double();
    }

    public void moveTo(double x, double y) {
        block0: {
            Path2D.Double double_ = this.path;
            if (double_ == null) break block0;
            double_.moveTo(x, y);
        }
    }

    public void lineTo(double x, double y) {
        block0: {
            Path2D.Double double_ = this.path;
            if (double_ == null) break block0;
            double_.lineTo(x, y);
        }
    }

    public void closePath() {
        block0: {
            Path2D.Double double_ = this.path;
            if (double_ == null) break block0;
            double_.closePath();
        }
    }

    public void drawShape(@NotNull DrawStyle s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Path2D.Double double_ = this.path;
        if (double_ == null) {
            Intrinsics.throwNpe();
        }
        this.draw(s, double_);
    }

    public void translate(double x, double y) {
        this.g.translate(x, y);
    }

    public void rotate(double degrees) {
        this.g.rotate(this.toRadians(degrees));
    }

    public void scale(double sx, double sy) {
        this.g.scale(sx, sy);
    }

    public void save() {
        Graphics2D graphics2D = this.g;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D, (String)"g");
        AffineTransform affineTransform = graphics2D.getTransform();
        Intrinsics.checkExpressionValueIsNotNull((Object)affineTransform, (String)"g.transform");
        this.ctm.add(affineTransform);
    }

    public void restore() {
        if (this.ctm.size() == 1) {
            throw (Throwable)new IllegalArgumentException("Restore without save");
        }
        Graphics2D graphics2D = this.g;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D, (String)"g");
        graphics2D.setTransform(this.ctm.remove(CollectionsKt.getLastIndex(this.ctm)));
    }

    public final void done() {
        this.g.dispose();
    }

    @NotNull
    public final BufferedImage getImg() {
        return this.img;
    }

    public ImageCanvas(@NotNull BufferedImage img) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        this.img = img;
        this.g = this.img.createGraphics();
        Object[] objectArray = new AffineTransform[1];
        Graphics2D graphics2D = this.g;
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics2D, (String)"g");
        AffineTransform affineTransform = graphics2D.getTransform();
        Intrinsics.checkExpressionValueIsNotNull((Object)affineTransform, (String)"g.transform");
        objectArray[0] = affineTransform;
        this.ctm = CollectionsKt.mutableListOf((Object[])objectArray);
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

