/*
 * Decompiled with CFR 0.152.
 */
package org.otfried.cs109emulator;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.otfried.cs109.Context;
import org.otfried.cs109emulator.JCanvas;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0017\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010W\u001a\u00020\b2\u0006\u0010X\u001a\u00020Y2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J!\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020J2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020J0^\u00a2\u0006\u0002\u0010_J!\u0010`\u001a\u00020J2\u0006\u0010a\u001a\u00020J2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020J0^\u00a2\u0006\u0002\u0010cJ$\u0010d\u001a\u00020\b2\u0006\u0010e\u001a\u00020J2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020g\u0012\u0004\u0012\u00020\b0?H\u0016J\u0006\u0010h\u001a\u00020\bJ(\u0010i\u001a\u00020\b2\u001e\u0010j\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020J\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070I0HH\u0016J\u0006\u0010k\u001a\u00020\bJ\u000e\u0010l\u001a\u00020\b2\u0006\u0010m\u001a\u00020\"J\u000e\u0010n\u001a\u00020\b2\u0006\u0010o\u001a\u00020\u0003J\u001e\u0010p\u001a\u00020\b2\u0006\u0010q\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010r\u001a\u00020\bJ$\u0010s\u001a\u00020\b2\u0006\u0010t\u001a\u00020J2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020\b0?H\u0016J\u0006\u0010u\u001a\u00020\bJ@\u0010v\u001a\u00020\b26\u0010Z\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\b0\u0016H\u0016Jj\u0010w\u001a\u00020\b2`\u0010Z\u001a\\\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\b0!H\u0016JU\u0010x\u001a\u00020\b2K\u0010Z\u001aG\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(/\u0012\u0004\u0012\u00020\b0.H\u0016J+\u0010y\u001a\u00020\b2!\u0010Z\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(@\u0012\u0004\u0012\u00020\b0?H\u0016J@\u0010z\u001a\u00020\b26\u0010Z\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\b0\u0016H\u0016J\u0010\u0010{\u001a\u00020\b2\u0006\u0010e\u001a\u00020JH\u0016J\u0010\u0010|\u001a\u00020\b2\u0006\u0010e\u001a\u00020JH\u0016J\u0010\u0010}\u001a\u00020\b2\u0006\u0010e\u001a\u00020JH\u0016J\b\u0010~\u001a\u00020\bH\u0016R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014RL\u0010\u0015\u001a4\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fRv\u0010 \u001a^\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\b\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,Ra\u0010-\u001aI\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(/\u0012\u0004\u0012\u00020\b\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010,R7\u0010>\u001a\u001f\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(@\u0012\u0004\u0012\u00020\b\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0011\u0010E\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u00107R4\u0010G\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020J\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070I\u0018\u00010HX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NRL\u0010O\u001a4\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u001d\"\u0004\bQ\u0010\u001fR\u0011\u0010R\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\u0010R\u0011\u0010T\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010,R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010;"}, d2={"Lorg/otfried/cs109emulator/UI;", "Lorg/otfried/cs109/Context;", "width", "", "height", "(II)V", "afterHandler", "Lkotlin/Function0;", "", "getAfterHandler", "()Lkotlin/jvm/functions/Function0;", "setAfterHandler", "(Lkotlin/jvm/functions/Function0;)V", "afterTimer", "Ljavax/swing/Timer;", "getAfterTimer", "()Ljavax/swing/Timer;", "canvas", "Lorg/otfried/cs109emulator/JCanvas;", "getCanvas", "()Lorg/otfried/cs109emulator/JCanvas;", "doubleTapHandler", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "getDoubleTapHandler", "()Lkotlin/jvm/functions/Function2;", "setDoubleTapHandler", "(Lkotlin/jvm/functions/Function2;)V", "flingHandler", "Lkotlin/Function4;", "", "dir", "dist", "getFlingHandler", "()Lkotlin/jvm/functions/Function4;", "setFlingHandler", "(Lkotlin/jvm/functions/Function4;)V", "gravityFrame", "Ljavax/swing/JFrame;", "getGravityFrame", "()Ljavax/swing/JFrame;", "gravityHandler", "Lkotlin/Function3;", "z", "getGravityHandler", "()Lkotlin/jvm/functions/Function3;", "setGravityHandler", "(Lkotlin/jvm/functions/Function3;)V", "gravityXSlider", "Ljavax/swing/JSlider;", "getGravityXSlider", "()Ljavax/swing/JSlider;", "gravityYSlider", "getGravityYSlider", "getHeight", "()I", "lightFrame", "getLightFrame", "lightHandler", "Lkotlin/Function1;", "lux", "getLightHandler", "()Lkotlin/jvm/functions/Function1;", "setLightHandler", "(Lkotlin/jvm/functions/Function1;)V", "lightSlider", "getLightSlider", "miniAppMenu", "", "Lkotlin/Pair;", "", "getMiniAppMenu", "()Ljava/util/List;", "setMiniAppMenu", "(Ljava/util/List;)V", "tapHandler", "getTapHandler", "setTapHandler", "toastTimer", "getToastTimer", "ui", "getUi", "getWidth", "after", "ms", "", "f", "askButtons", "question", "buttons", "", "(Ljava/lang/String;[Ljava/lang/String;)I", "askChoice", "msg", "choices", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "askYesNo", "s", "handle", "", "clearToast", "createMenu", "items", "gravityChange", "handleKey", "ch", "handleMenuItem", "item", "handleMouse", "button", "handleTimeout", "inputString", "prompt", "lightChange", "onDoubleTap", "onFling", "onGravity", "onLight", "onTap", "setTitle", "showMessage", "toast", "update"})
final class UI
implements Context {
    @NotNull
    private final JCanvas canvas;
    @NotNull
    private final JFrame ui;
    @Nullable
    private List<? extends Pair<String, ? extends Function0<Unit>>> miniAppMenu;
    @NotNull
    private final JSlider lightSlider;
    @NotNull
    private final JFrame lightFrame;
    @NotNull
    private final JSlider gravityXSlider;
    @NotNull
    private final JSlider gravityYSlider;
    @NotNull
    private final JFrame gravityFrame;
    @NotNull
    private final Timer toastTimer;
    @NotNull
    private final Timer afterTimer;
    @Nullable
    private Function2<? super Double, ? super Double, Unit> tapHandler;
    @Nullable
    private Function2<? super Double, ? super Double, Unit> doubleTapHandler;
    @Nullable
    private Function4<? super Double, ? super Double, ? super Character, ? super Double, Unit> flingHandler;
    @Nullable
    private Function0<Unit> afterHandler;
    @Nullable
    private Function3<? super Double, ? super Double, ? super Double, Unit> gravityHandler;
    @Nullable
    private Function1<? super Double, Unit> lightHandler;
    private final int width;
    private final int height;

    @NotNull
    public final JCanvas getCanvas() {
        return this.canvas;
    }

    @NotNull
    public final JFrame getUi() {
        return this.ui;
    }

    @Nullable
    public final List<Pair<String, Function0<Unit>>> getMiniAppMenu() {
        return this.miniAppMenu;
    }

    public final void setMiniAppMenu(@Nullable List<? extends Pair<String, ? extends Function0<Unit>>> list) {
        this.miniAppMenu = list;
    }

    @NotNull
    public final JSlider getLightSlider() {
        return this.lightSlider;
    }

    @NotNull
    public final JFrame getLightFrame() {
        return this.lightFrame;
    }

    @NotNull
    public final JSlider getGravityXSlider() {
        return this.gravityXSlider;
    }

    @NotNull
    public final JSlider getGravityYSlider() {
        return this.gravityYSlider;
    }

    @NotNull
    public final JFrame getGravityFrame() {
        return this.gravityFrame;
    }

    @NotNull
    public final Timer getToastTimer() {
        return this.toastTimer;
    }

    @NotNull
    public final Timer getAfterTimer() {
        return this.afterTimer;
    }

    @Nullable
    public final Function2<Double, Double, Unit> getTapHandler() {
        return this.tapHandler;
    }

    public final void setTapHandler(@Nullable Function2<? super Double, ? super Double, Unit> function2) {
        this.tapHandler = function2;
    }

    @Nullable
    public final Function2<Double, Double, Unit> getDoubleTapHandler() {
        return this.doubleTapHandler;
    }

    public final void setDoubleTapHandler(@Nullable Function2<? super Double, ? super Double, Unit> function2) {
        this.doubleTapHandler = function2;
    }

    @Nullable
    public final Function4<Double, Double, Character, Double, Unit> getFlingHandler() {
        return this.flingHandler;
    }

    public final void setFlingHandler(@Nullable Function4<? super Double, ? super Double, ? super Character, ? super Double, Unit> function4) {
        this.flingHandler = function4;
    }

    @Nullable
    public final Function0<Unit> getAfterHandler() {
        return this.afterHandler;
    }

    public final void setAfterHandler(@Nullable Function0<Unit> function0) {
        this.afterHandler = function0;
    }

    @Nullable
    public final Function3<Double, Double, Double, Unit> getGravityHandler() {
        return this.gravityHandler;
    }

    public final void setGravityHandler(@Nullable Function3<? super Double, ? super Double, ? super Double, Unit> function3) {
        this.gravityHandler = function3;
    }

    @Nullable
    public final Function1<Double, Unit> getLightHandler() {
        return this.lightHandler;
    }

    public final void setLightHandler(@Nullable Function1<? super Double, Unit> function1) {
        this.lightHandler = function1;
    }

    public void update() {
        this.canvas.setRedrawApp(true);
        this.canvas.repaint();
    }

    public void setTitle(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.ui.setTitle(s);
    }

    public void toast(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.canvas.setToast(s);
        this.toastTimer.start();
        this.canvas.repaint();
    }

    public final void clearToast() {
        this.canvas.setToast(null);
        this.canvas.repaint();
    }

    public void onTap(@NotNull Function2<? super Double, ? super Double, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        this.tapHandler = f;
    }

    public void onDoubleTap(@NotNull Function2<? super Double, ? super Double, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        this.doubleTapHandler = f;
    }

    public void onFling(@NotNull Function4<? super Double, ? super Double, ? super Character, ? super Double, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        this.flingHandler = f;
    }

    public void onGravity(@NotNull Function3<? super Double, ? super Double, ? super Double, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        this.gravityHandler = f;
        this.gravityFrame.setVisible(true);
        this.gravityChange();
    }

    public final void gravityChange() {
        block0: {
            double x = (double)this.gravityXSlider.getValue() / 10.0;
            double y = (double)this.gravityYSlider.getValue() / 10.0;
            double z = 1.0;
            double norm = Math.sqrt(x * x + y * y + z * z);
            double g = 9.81;
            Function3<? super Double, ? super Double, ? super Double, Unit> function3 = this.gravityHandler;
            if (function3 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)(g * x / norm), (Object)(g * y / norm), (Object)(g * z / norm));
        }
    }

    public void onLight(@NotNull Function1<? super Double, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        this.lightHandler = f;
        this.lightFrame.setVisible(true);
        this.lightChange();
    }

    public final void lightChange() {
        block0: {
            double lux = this.lightSlider.getValue();
            Function1<? super Double, Unit> function1 = this.lightHandler;
            if (function1 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)lux);
        }
    }

    public void after(long ms, @NotNull Function0<Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        this.afterTimer.stop();
        this.afterTimer.setInitialDelay((int)ms);
        this.afterHandler = f;
        this.afterTimer.start();
    }

    public final void handleTimeout() {
        block0: {
            Function0<Unit> function0 = this.afterHandler;
            if (function0 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createMenu(@NotNull List<? extends Pair<String, ? extends Function0<Unit>>> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this.miniAppMenu = items;
        JMenu menu = new JMenu("Menu");
        int n = 0;
        int n2 = ((Collection)items).size();
        while (n < n2) {
            void i;
            JMenuItem item = new JMenuItem((String)items.get((int)i).getFirst());
            item.addActionListener(new ActionListener(this, (int)i){
                final /* synthetic */ UI this$0;
                final /* synthetic */ int $i;

                public final void actionPerformed(ActionEvent it) {
                    this.this$0.handleMenuItem(this.$i);
                }
                {
                    this.this$0 = uI;
                    this.$i = n;
                }
            });
            menu.add(item);
            ++i;
        }
        JMenuBar menubar = new JMenuBar();
        menubar.add(menu);
        this.ui.setJMenuBar(menubar);
    }

    public final void handleMenuItem(int item) {
        block0: {
            List<? extends Pair<String, ? extends Function0<Unit>>> list;
            List<? extends Pair<String, ? extends Function0<Unit>>> m;
            List<? extends Pair<String, ? extends Function0<Unit>>> list2 = m = this.miniAppMenu;
            if (list2 == null) break block0;
            List<? extends Pair<String, ? extends Function0<Unit>>> it = list = list2;
            ((Function0)m.get(item).getSecond()).invoke();
        }
    }

    public final void handleKey(char ch) {
        block1: {
            double x = (double)this.getWidth() / 2.0;
            double y = (double)this.getHeight() / 2.0;
            double dist = 200.0;
            if (!StringsKt.contains$default((CharSequence)"udlr", (char)ch, (boolean)false, (int)2, null)) break block1;
            Function4<? super Double, ? super Double, ? super Character, ? super Double, Unit> function4 = this.flingHandler;
            if (function4 != null) {
                Unit cfr_ignored_0 = (Unit)function4.invoke((Object)x, (Object)y, (Object)Character.valueOf(ch), (Object)dist);
            }
        }
    }

    public final void handleMouse(int button, double x, double y) {
        switch (button) {
            case 1: {
                Function2<? super Double, ? super Double, Unit> function2 = this.tapHandler;
                if (function2 != null) {
                    Unit cfr_ignored_0 = (Unit)function2.invoke((Object)x, (Object)y);
                }
                break;
            }
            case 3: {
                Function2<? super Double, ? super Double, Unit> function2 = this.doubleTapHandler;
                if (function2 == null) break;
                Unit cfr_ignored_1 = (Unit)function2.invoke((Object)x, (Object)y);
                break;
            }
        }
    }

    public void showMessage(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        JOptionPane.showMessageDialog(this.canvas, s, this.ui.getTitle(), -1);
    }

    public void askYesNo(@NotNull String s, @NotNull Function1<? super Boolean, Unit> handle) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(handle, (String)"handle");
        int r = JOptionPane.showConfirmDialog(this.canvas, s, this.ui.getTitle(), 0, -1);
        handle.invoke((Object)(r == 0 ? 1 : 0));
    }

    public void inputString(@NotNull String prompt, @NotNull Function1<? super String, Unit> handle) {
        Intrinsics.checkParameterIsNotNull((Object)prompt, (String)"prompt");
        Intrinsics.checkParameterIsNotNull(handle, (String)"handle");
        Object r = JOptionPane.showInputDialog(this.canvas, prompt, this.ui.getTitle(), -1, null, null, "");
        if (r instanceof String) {
            handle.invoke(r);
        }
    }

    public final int askButtons(@NotNull String question, @NotNull String[] buttons) {
        Intrinsics.checkParameterIsNotNull((Object)question, (String)"question");
        Intrinsics.checkParameterIsNotNull((Object)buttons, (String)"buttons");
        int result = 0;
        int r = JOptionPane.showOptionDialog(this.canvas, question, this.ui.getTitle(), 1, -1, null, buttons, null);
        if (r != -1) {
            result = r + 1;
        }
        return result;
    }

    @NotNull
    public final String askChoice(@NotNull String msg, @NotNull String[] choices) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)choices, (String)"choices");
        String result = "";
        Object r = JOptionPane.showInputDialog(this.canvas, msg, this.ui.getTitle(), -1, null, choices, null);
        if (r instanceof String) {
            result = (String)r;
        }
        return result;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public UI(int width, int height) {
        this.width = width;
        this.height = height;
        this.canvas = new JCanvas(this.getWidth(), this.getHeight(), this);
        this.ui = new JFrame();
        this.lightSlider = new JSlider(0, 1, 1000, 20);
        this.lightFrame = new JFrame();
        this.gravityXSlider = new JSlider(0, -100, 100, 0);
        this.gravityYSlider = new JSlider(0, -100, 100, 0);
        this.gravityFrame = new JFrame();
        this.ui.setDefaultCloseOperation(3);
        this.ui.setTitle("CS109 emulator");
        this.ui.setResizable(false);
        this.ui.add(this.canvas);
        this.ui.pack();
        this.lightSlider.setPreferredSize(new Dimension(400, 100));
        this.lightSlider.addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent it) {
                this.lightChange();
            }
        });
        this.lightFrame.setTitle("Light sensor");
        this.lightFrame.add(this.lightSlider);
        this.lightFrame.pack();
        this.gravityXSlider.setPaintTicks(true);
        this.gravityYSlider.setPaintTicks(true);
        this.gravityXSlider.setMajorTickSpacing(100);
        this.gravityYSlider.setMajorTickSpacing(100);
        this.gravityXSlider.addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent it) {
                this.gravityChange();
            }
        });
        this.gravityYSlider.addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent it) {
                this.gravityChange();
            }
        });
        JPanel gpanel = new JPanel();
        gpanel.setBorder(BorderFactory.createEmptyBorder(30, 10, 30, 10));
        gpanel.setLayout(new BoxLayout(gpanel, 1));
        gpanel.add(this.gravityXSlider);
        gpanel.add(Box.createRigidArea(new Dimension(0, 30)));
        gpanel.add(this.gravityYSlider);
        this.gravityFrame.setTitle("Gravity sensor");
        this.gravityFrame.add(gpanel);
        this.gravityFrame.pack();
        this.toastTimer = new Timer(2000, new ActionListener(this){
            final /* synthetic */ UI this$0;

            public final void actionPerformed(ActionEvent it) {
                this.this$0.clearToast();
            }
            {
                this.this$0 = uI;
            }
        });
        this.afterTimer = new Timer(2000, new ActionListener(this){
            final /* synthetic */ UI this$0;

            public final void actionPerformed(ActionEvent it) {
                this.this$0.handleTimeout();
            }
            {
                this.this$0 = uI;
            }
        });
    }
}

