/*
 * Decompiled with CFR 0.152.
 */
package org.otfried.cs109emulator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.otfried.cs109.Canvas;
import org.otfried.cs109.MiniApp;
import org.otfried.cs109emulator.UI;
import org.otfried.cs109ui.ImageCanvas;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!"}, d2={"Lorg/otfried/cs109emulator/JCanvas;", "Ljavax/swing/JComponent;", "w", "", "h", "handler", "Lorg/otfried/cs109emulator/UI;", "(IILorg/otfried/cs109emulator/UI;)V", "getHandler", "()Lorg/otfried/cs109emulator/UI;", "image", "Ljava/awt/image/BufferedImage;", "miniApp", "Lorg/otfried/cs109/MiniApp;", "getMiniApp", "()Lorg/otfried/cs109/MiniApp;", "setMiniApp", "(Lorg/otfried/cs109/MiniApp;)V", "redrawApp", "", "getRedrawApp", "()Z", "setRedrawApp", "(Z)V", "toast", "", "getToast", "()Ljava/lang/String;", "setToast", "(Ljava/lang/String;)V", "toastFont", "Ljava/awt/Font;", "getToastFont", "()Ljava/awt/Font;", "paintComponent", "", "gr", "Ljava/awt/Graphics;"})
final class JCanvas
extends JComponent {
    private BufferedImage image;
    @Nullable
    private MiniApp miniApp;
    @Nullable
    private String toast;
    private boolean redrawApp;
    @NotNull
    private final Font toastFont;
    @NotNull
    private final UI handler;

    @Nullable
    public final MiniApp getMiniApp() {
        return this.miniApp;
    }

    public final void setMiniApp(@Nullable MiniApp miniApp) {
        this.miniApp = miniApp;
    }

    @Nullable
    public final String getToast() {
        return this.toast;
    }

    public final void setToast(@Nullable String string) {
        this.toast = string;
    }

    public final boolean getRedrawApp() {
        return this.redrawApp;
    }

    public final void setRedrawApp(boolean bl) {
        this.redrawApp = bl;
    }

    @NotNull
    public final Font getToastFont() {
        return this.toastFont;
    }

    @Override
    protected void paintComponent(@NotNull Graphics gr) {
        block2: {
            String string;
            String t;
            Intrinsics.checkParameterIsNotNull((Object)gr, (String)"gr");
            ImageCanvas gc = new ImageCanvas(this.image);
            if (this.redrawApp) {
                MiniApp miniApp = this.miniApp;
                if (miniApp != null) {
                    miniApp.onDraw((Canvas)gc);
                }
            }
            this.redrawApp = false;
            gc.done();
            Graphics2D g = (Graphics2D)gr;
            g.drawImage(this.image, null, 0, 0);
            String string2 = t = this.toast;
            if (string2 == null) break block2;
            String it = string = string2;
            g.setFont(this.toastFont);
            int x = this.getWidth() / 2;
            int y = this.getHeight() - 60;
            int w = g.getFontMetrics().stringWidth(t) / 2;
            g.setColor(Color.BLUE);
            g.drawString(t, x - w, y);
        }
    }

    @NotNull
    public final UI getHandler() {
        return this.handler;
    }

    public JCanvas(int w, int h, @NotNull UI handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        this.handler = handler;
        this.image = new BufferedImage(w, h, 1);
        this.redrawApp = true;
        this.toastFont = new Font("sans-serif", 0, 32);
        this.setPreferredSize(new Dimension(w, h));
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.getHandler().handleKey(e.getKeyChar());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.getHandler().handleMouse(e.getButton(), e.getX(), e.getY());
            }
        });
    }
}

